## Functions for calculating P{pE <= q| MYCYC data}, P{pE <= q|MYPAN, MYCYC data}, P{pC <= q|MYCYC data}, P{pC <= q|MYPAN, MYCYC data}, 
## P{theta <= q| MYCYC data}, P{theta <= q|MYCYC, MYPAN data}.

## Function inputs: 	quant, prob = wish to calculate P(pE <= quant|MYPAN data, mycyc data) - prob or P(pE <= quant|mycyc data) - prob
##						priNormEC = normalising constant for joint prior density of (pE, pC) incorporating MYCYC data
##						postNormEC = normalising constant for joint prior density of (pE, pC) incorporating MYCYC data and hypothetical MYPAN trial dataset
##						a, b = parameters of prior distribution of pC~Beta(a,b) without knowledge of the MYCYC data
##						lCparam, lEparam = vectors containing parameters of prior distributions of lambdaC and lambdaE (means and variances)
##						mu, sigma2 = mean and variance of normal prior distribution for theta without knowledge of the MYCYC data
##						(se, fe, sc, fc) = number of successes and failures on MMF and CYC in hypothetical MYPAN trial dataset
##						mycyc = vector containing summaries of mycyc data
##						posterior = logical variable determining whether function calculates P(pE <= quant|MYPAN data, mycyc data) (posterior =="T") 
##						or P(pE <= quant|mycyc data) (posterior =="F").
## Function returns: 	P(pE <= quant|MYPAN data, mycyc data) - prob or P(pE <= quant|mycyc data) - prob	 

D2prob_pE <- function(quant, prob, priNormEC, postNormEC, a, b, lCparam,lEparam, mu, sigma2, sc, fc, se, fe, mycyc, posterior){

	## Set up a grid to integrate pE over [0, q] with midpoints
	x1 = floor((quant - 0.001)/0.004)
	uppbd = 0.001 + x1*0.004
	if(x1 == ((quant-0.001)/0.004)){
		gride = seq(0.001, quant, by = 0.002)
	}else{
		midpt = (uppbd + quant)/2.0
		gride = append(seq(0.001, uppbd, by=0.002), c(midpt, quant))	
	}
	le = length(gride)

	## Calculate Simpson's integration weights
	we  = vector(mode="numeric", length=le)
  	we[1] = (gride[3]-gride[1])/6.0
  	we[le] = (gride[le] - gride[le-2])/6.0
  	if(le-1 >= 2){
 		for(i in seq(2, (le-1), by=2)){
    		we[i] = 4*(gride[i+1] - gride[i-1])/6.0
 		}
 	}
 	if(le-2 >= 3){
 		for(i in seq(3, (le-2), by=2)){
    		we[i] = (gride[i+2] - gride[i-2])/6.0
 		}
 	}
  	
  	## Mesh for integrating pC across the interval (0, 1)
    gridc = seq(0.001, 0.999, by=0.001)
    midp1 = (0.00001 + 0.001)*0.5
    midp2 = (0.99999 + 0.999)*0.5
    gridc = append(c(0.00001, midp1), gridc)
    gridc = append(gridc, c(midp2, 0.99999))
  	lc = length(gridc)
  	wc  = vector(mode="numeric", length=lc)
  	wc[1] = (gridc[3]-gridc[1])/6.0
  	wc[lc] = (gridc[lc] - gridc[lc-2])/6.0
  	for(i in seq(2, lc-1, by=2)){
    	wc[i] = 4*(gridc[i+1] - gridc[i-1])/6.0
  	}
  	for(i in seq(3, lc-2, by=2)){
    	wc[i] = (gridc[i+2] - gridc[i-2])/6.0
  	}

  	intpca = vector(mode="numeric", lc)
  	denspc = vector(mode="numeric", lc)
  	intpe = vector(mode="numeric", le)
  	
  	gridca = gridc
  	gridea = gridc
  	
  	if(!posterior){
  		## Evaluate P{pE <= q| zr}
 		for(j in 1:lc){
  			const1 = dnorm(log(gridca*(1-gridc[j])/(gridc[j]*(1-gridca))), mean = lCparam[1], sd = sqrt(lCparam[2]))
    		dens = (gridca^(mycyc[1]-1))*((1 - gridca)^(mycyc[2]-1))*const1
    		intpca[j] = sum(wc*dens)
  		}
  	
  		for(i in 1:le){
  			const1 = dnorm(log(gridea*(1-gride[i])/(gride[i]*(1-gridea))), mean = lEparam[1], sd = sqrt(lEparam[2]))
    		dens = (gridea^(mycyc[3] - 1))*((1-gridea)^(mycyc[4]-1))*const1
			intpea = sum(wc*dens)
  			for(j in 1:lc){	
    			const1 = dnorm(log(gride[i]*(1-gridc[j])/(gridc[j]*(1 - gride[i]))), mean = mu, sd = sqrt(sigma2))
    			denspc[j] = priNormEC*const1*intpca[j]*intpea*dbeta(gridc[j], shape1=a, shape2=b)/(gride[i]*(1-gride[i]))
  			}
  			intpe[i] = sum(wc*denspc)
  		}	
  	}else{
  		## Evaluate P{pE <= q| data, zr}	
		for(j in 1:lc){
  			const1 = dnorm(log(gridca*(1-gridc[j])/(gridc[j]*(1-gridca))), mean = lCparam[1], sd = sqrt(lCparam[2]))
    		dens = (gridca^(mycyc[1]-1))*((1 - gridca)^(mycyc[2]-1))*const1
    		intpca[j] = sum(wc*dens)
  		}

  		for(i in 1:le){
  			const1 = dnorm(log(gridea*(1-gride[i])/(gride[i]*(1-gridea))), mean = lEparam[1], sd = sqrt(lEparam[2]))
    		dens = (gridea^(mycyc[3] - 1))*((1-gridea)^(mycyc[4]-1))*const1
			intpea = sum(wc*dens)
  			for(j in 1:lc){	
    			const1 = dnorm(log(gride[i]*(1-gridc[j])/(gridc[j]*(1 - gride[i]))), mean = mu, sd = sqrt(sigma2))
    			denspc[j] = priNormEC*const1*intpca[j]*intpea*dbeta(gridc[j], shape1=a, shape2=b)/(gride[i]*(1-gride[i]))
    			denspc[j] = denspc[j]*(gridc[j]^sc)*((1-gridc[j])^fc)
  			}
  			intpe[i] = postNormEC*sum(wc*denspc)*(gride[i]^se)*((1-gride[i])^fe)
  		}
	}
	return(sum(we*intpe) - prob)
}

## Function inputs: 	quant, prob = wish to calculate P(pC <= quant|MYPAN data, mycyc data) - prob or P(pC <= quant|mycyc data) - prob
##						priNormEC = normalising constant for joint prior density of (pE, pC) incorporating MYCYC data
##						postNormEC = normalising constant for joint prior density of (pE, pC) incorporating MYCYC data and hypothetical MYPAN trial dataset
##						a, b = parameters of prior distribution of pC~Beta(a,b) without knowledge of the MYCYC data
##						lCparam, lEparam = vectors containing parameters of prior distributions of lambdaC and lambdaE (means and variances)
##						mu, sigma2 = mean and variance of normal prior distribution for theta without knowledge of the MYCYC data
##						mycyc = vector containing summaries of mycyc data
##						(se, fe, sc, fc) = number of successes and failures on MMF and CYC in hypothetical MYPAN trial dataset
##						posterior = logical variable determining whether function calculates P(pE <= quant|MYPAN data, mycyc data) (posterior =="T") 
##						or P(pE <= quant|mycyc data) (posterior =="F").
## Function returns: 	P(pC <= quant|MYPAN data, mycyc data) - prob or P(pC <= quant|mycyc data) - prob

D2prob_pC <-function(quant, prob, priNormEC, postNormEC, a, b, lCparam, lEparam, mu, sigma2, mycyc, se, sc, fe, fc, posterior){

	## Set up a grid to integrate pC over [0, q] with midpoints
	x1 = floor((quant - 0.001)/0.004)
	uppbd = 0.001 + x1*0.004
	if(x1 == ((quant -0.001)/0.004)){
		gridc = seq(0.001, quant, by = 0.002)
	}else{
		midpt = (uppbd + quant)/2.0
		gridc = append(seq(0.001, uppbd, by=0.002), c(midpt, quant))	
	}
	lc = length(gridc)
	## Calculate Simpson's integration weights
	wc  = vector(mode="numeric", length=lc)
  	wc[1] = (gridc[3]-gridc[1])/6.0
  	wc[lc] = (gridc[lc] - gridc[lc-2])/6.0
 	for(i in seq(2, (lc-1), by=2)){
    	wc[i] = 4*(gridc[i+1] - gridc[i-1])/6.0
 	}
 	if(lc -2 >= 3){
 		for(i in seq(3, (lc-2), by=2)){
    		wc[i] = (gridc[i+2] - gridc[i-2])/6.0
 		}
 	}
 	
 	## Mesh for integrating pE across the interval (0, 1)
    gride = seq(0.001, 0.999, by=0.001)
    midp1 = (0.00001 + 0.001)*0.5
    midp2 = (0.99999 + 0.999)*0.5
    gride = append(c(0.00001, midp1), gride)
    gride = append(gride, c(midp2, 0.99999))
  	le = length(gride)
  	we  = vector(mode="numeric", length=le)
  	we[1] = (gride[3]-gride[1])/6.0
  	we[le] = (gride[le] - gride[le-2])/6.0
  	for(i in seq(2, le-1, by=2)){
    	we[i] = 4*(gride[i+1] - gride[i-1])/6.0
  	}
  	for(i in seq(3, le-2, by=2)){
    	we[i] = (gride[i+2] - gride[i-2])/6.0
  	}

	gridea = gride
  	gridca = gride
 	denspc = vector(mode="numeric", length = le)
  	intpc = vector(mode="numeric", length = lc)
  	intpea = vector(mode="numeric", length = le)
  	
  	if(!posterior){
  		## Evaluate P{pC <= q | zr}		 	
  		for(j in 1:le){
  			const1 = dnorm(log(gridea*(1-gride[j])/(gride[j]*(1-gridea))), mean = lEparam[1], sd = sqrt(lEparam[2]))
    		dens = (gridea^(mycyc[3] - 1))*((1-gridea)^(mycyc[4]-1))*const1
			intpea[j] = sum(we*dens)
  		}
  	
  		for(i in 1:lc){
  			const1 = dnorm(log(gridca*(1-gridc[i])/(gridc[i]*(1-gridca))), mean=lCparam[1], sd = sqrt(lCparam[2]))
    		dens = (gridca^(mycyc[1]-1))*((1 - gridca)^(mycyc[2]-1))*const1
    		intpca = sum(we*dens)
  			for(j in 1:le){	
    			const1 = dnorm(log(gride[j]*(1-gridc[i])/(gridc[i]*(1 - gride[j]))), mean = mu, sd = sqrt(sigma2))
    			denspc[j] = priNormEC*const1*intpca*intpea[j]*dbeta(gridc[i], shape1=a, shape2=b)/(gride[j]*(1-gride[j]))
  			}
  			intpc[i] = sum(we*denspc)
  		}	
   	  }else{
   	  	## Evaluate P{pC <= q | data, zr}		
  		for(j in 1:le){
  			const1 = dnorm(log(gridea*(1-gride[j])/(gride[j]*(1-gridea))), mean = lEparam[1], sd = sqrt(lEparam[2]))
    		dens = (gridea^(mycyc[3] - 1))*((1-gridea)^(mycyc[4]-1))*const1
			intpea[j] = sum(we*dens)
  		}
  	
  		for(i in 1:lc){
  			const1 = dnorm(log(gridca*(1-gridc[i])/(gridc[i]*(1-gridca))), mean=lCparam[1], sd = sqrt(lCparam[2]))
    		dens = (gridca^(mycyc[1]-1))*((1 - gridca)^(mycyc[2]-1))*const1
    		intpca = sum(we*dens)
  			for(j in 1:le){	
    			const1 = dnorm(log(gride[j]*(1-gridc[i])/(gridc[i]*(1 - gride[j]))), mean = mu, sd = sqrt(sigma2))
    			denspc[j] = priNormEC*const1*intpca*intpea[j]*dbeta(gridc[i], shape1=a, shape2=b)/(gride[j]*(1-gride[j]))
    			denspc[j] = denspc[j]*(gride[j]^se)*((1-gride[j])^fe)
  			}
  			intpc[i] = postNormEC*sum(we*denspc)*(gridc[i]^sc)*((1-gridc[i])^fc)
  		}
	}
	return(sum(wc*intpc) - prob)
}

## Function inputs: 	quant, prob = wish to calculate P(theta <= quant|MYPAN data, mycyc data) - prob or P(theta <= quant|mycyc data) - prob
##						postNormTC = normalising constant for joint posterior density of (pC, theta) incorporating MYCYC data and hypothetical MYPAN trial dataset
##						priNormEC = normalising constant for joint prior density of (pE, pC) incorporating MYCYC data
##						(se, fe, sc, fc) = number of successes and failures on MMF and CYC in hypothetical MYPAN trial dataset
##						mycyc = vector containing summaries of mycyc data
##						a, b = parameters of prior distribution of pC~Beta(a,b) without knowledge of the MYCYC data
##						lCparam, lEparam = vectors containing parameters of prior distributions of lambdaC and lambdaE (means and variances)
##						mu, sigma2 = mean and variance of normal prior distribution for theta without knowledge of the MYCYC data
##						thetaExp, thetaSd = expectation and SD or prior or posterior distribution of theta (incorporating MYCYC data)
##						posterior = logical variable determining whether function calculates P(pE <= quant|MYPAN data, mycyc data) (posterior =="T") 
##						or P(pE <= quant|mycyc data) (posterior =="F").
## Function returns: 	P(theta <= quant|MYPAN data, mycyc data) - prob or P(theta <= quant|mycyc data) - prob

D2prob_theta <- function(quant, prob, postNormTC, priNormEC, se, sc, fe, fc, mycyc, a, b, lCparam, lEparam, mu, sigma2, thetaExp, thetaSd, posterior){

	r = as.integer(16)
   	mesh = as.integer(6*r -1)
   	index = as.integer(mesh)
   	grid1 = vector(mode="numeric", length= mesh)
   	## Construct a mesh for integrating over theta which is efficient for integrating 
   	## over the posterior (or prior) density incorporating MYCYC data (assuming prior/posterior is approximately normal)
   	for(i in 1:mesh){
   		if(i <= (r-1)){
   			grid1[i] = thetaExp + thetaSd*(-3 - 4*log(r/i))
   		}else if((i >= r) & (i<= 5*r)){
   			grid1[i] = thetaExp + thetaSd*(-3 + 3*(i-r)/(2*r))
   		}else{
   			grid1[i] = thetaExp + thetaSd*(3 + 4*log(r/(6*r -i)))
  		}
  	}  
  	for(i in mesh:1){
   		if(grid1[i] > quant){
   			grid1[i] = quant
   			index = i
   		}
   	}
   	if(index == 1){
   		grid1[1] = quant - 0.1
   		grid1[2] = quant
   		index = 2
   	}
   	mesh1 = 2*index -1
   	gridt = vector(mode="numeric", length= mesh1)
   	## Keep elements 1:index of grid1 
   	for(i in seq(1, index, by=1)){
   		gridt[2*i-1] = grid1[i]	
   	}
   	for(i in seq(2, mesh1-1, by=2)){
   		gridt[i] = (gridt[i+1] + gridt[i-1])/2.0
   	}
	## calculating Simpson's integration weights
   	wtheta  = vector(mode="numeric", length=mesh1)
    wtheta[1] = (gridt[3]-gridt[1])/6.0
  	wtheta[mesh1] = (gridt[mesh1] - gridt[mesh1-2])/6.0
  	for(i in seq(2, (mesh1-1), by=2)){
    	wtheta[i] = 4*(gridt[i+1] - gridt[i-1])/6.0
   	}
   	if(mesh1-2 >= 3){
   		for(i in seq(3, (mesh1-2), by=2)){
			wtheta[i] = (gridt[i+2] - gridt[i-2])/6.0
   		}
   	} 
   	## Create a grid for integrating pC over (0,1)
	gridc = seq(0.001, 0.999, by=0.001)
    midp1 = (0.00001 + 0.001)*0.5
    midp2 = (0.99999 + 0.999)*0.5
    gridc = append(c(0.00001, midp1), gridc)
    gridc = append(gridc, c(midp2, 0.99999))  
    lc = length(gridc)
	wc  = vector(mode="numeric", length=lc)
  	wc[1] = (gridc[3]-gridc[1])/6.0
  	wc[lc] = (gridc[lc] - gridc[lc-2])/6.0
  	for(i in seq(2, lc-1, by=2)){
    	wc[i] = 4*(gridc[i+1] - gridc[i-1])/6.0
  	}
  	for(i in seq(3, lc-2, by=2)){
    	wc[i] = (gridc[i+2] - gridc[i-2])/6.0
  	}	
  	
	## Create a grid for integrating over dummy variables pER and pCR
  	grider = gridc
	int = vector(mode="numeric", length=mesh1)
	denspc = vector(mode="numeric", length=lc)
	
   	if(!posterior){
  		int1 = (grider^(mycyc[3] -1))*((1-grider)^(mycyc[4]-1))
  		int2 = (grider^(mycyc[1]-1))*((1-grider)^(mycyc[2]-1))
  		for(i in 1:mesh1){
  		## Integrate over joint density of (theta, pC)|zr	
  			for(j in 1:lc){
  				int3 = int1*dnorm(log(grider*(1-gridc[j])/((1-grider)*gridc[j]*exp(gridt[i]))), mean = lEparam[1], sd = sqrt(lEparam[2]))
  				int4 = int2*dnorm(log(grider*(1-gridc[j])/((1-grider)*gridc[j])), mean = lCparam[1], sd = sqrt(lCparam[2]))
  				denspc[j] = sum(wc*int3)*sum(wc*int4)*dbeta(gridc[j], shape1 = a, shape2=b)
  			}
  			int[i] = dnorm(gridt[i], mean=mu, sd = sqrt(sigma2))*sum(wc*denspc)*priNormEC
		}	
   	}else{
		## P{theta <= q| zr, mypan}
		int1 = (grider^(mycyc[3] -1))*((1-grider)^(mycyc[4]-1))
  		int2 = (grider^(mycyc[1]-1))*((1-grider)^(mycyc[2]-1))
  		for(i in 1:mesh1){
  			## Integrate over joint density of (theta, pC)|zr, mypan data	
  			for(j in 1:lc){
  				phi = gridc[j]*exp(gridt[i])/(gridc[j]*(exp(gridt[i]) -1) +1)
  				int3 = int1*dnorm(log(grider*(1-phi)/(phi*(1-grider))), mean = lEparam[1], sd = sqrt(lEparam[2]))
  				int4 = int2*dnorm(log(grider*(1-gridc[j])/((1-grider)*gridc[j])), mean = lCparam[1], sd = sqrt(lCparam[2]))
  				denspc[j] = sum(wc*int3)*sum(wc*int4)*dbeta(gridc[j], shape1 = a, shape2=b)*priNormEC/(phi*(1-phi))
  				denspc[j] = denspc[j]*dnorm(log(phi*(1-gridc[j])/(gridc[j]*(1-phi))), mean = mu, sd = sqrt(sigma2))
  				denspc[j] = denspc[j]*(gridc[j]^(se+sc+1))*((1-gridc[j])^(fe+fc+1))/((gridc[j]*(exp(gridt[i]) -1) +1)^(se+fe+2))
  			}
  			int[i] = postNormTC*sum(wc*denspc)*exp((se+1)*gridt[i])
		}
	}
	   	
	return(sum(wtheta*int) - prob)
}